(ns struktur.dev.test
  (:require
   [clojure.test :as t]
   [com.stuartsierra.component :as c]))

(def ^:dynamic *system* nil)

(defn with-system
  [system]
  (fn [f]
    (let [started (c/start (system))]
      (try (binding [*system* started] (f))
           (finally (c/stop started))))))
