(ns struktur.dev.repl
  (:require
   [clojure.tools.namespace.repl :refer [disable-reload! refresh]]
   [com.stuartsierra.component :as c]))

(disable-reload!)

(def system nil)
(def initializer nil)

(defn set-init!
  [f]
  (alter-var-root #'initializer (constantly f))
  ::ok)

(defn start!
  []
  (alter-var-root #'system initializer)
  (alter-var-root #'system c/start)
  ::ok)

(defn stop!
  []
  (alter-var-root #'system #(when % (c/stop %)))
  ::ok)

(defn restart!
  []
  (stop!)
  (let [result (refresh :after 'struktur.repl/start!)]
    (if (instance? Throwable result)
      (throw result)
      result)))

(defrecord SystemWrapper [config system started]
  c/Lifecycle
  (start [this]
    (let [current-system (system config)]
      (assoc this :started (c/start current-system))))
  (stop [this]
    (when started (c/stop started))
    (assoc this :started nil)))

(defn new-system-wrapper
  [config system]
  (map->SystemWrapper {:config config :system system}))
