(ns struktur.aleph
  (:require
   [aleph.http :as aleph]
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]))

(defn apply-default-config
  [config]
  (merge {:port 8080 :compression? true} config))

(defrecord HttpServer [config ring-handler server]
  c/Lifecycle
  (start [this]
    (let [handler (:handler ring-handler ring-handler)
          server (aleph/start-server handler (apply-default-config config))]
      (assoc this :server server)))
  (stop [this]
    (when (some? server) (.close server))
    (assoc this :server nil)))

(defn new-http-server
  [config]
  (map->HttpServer {:config config}))
