(ns struktur.aleph
  (:require
   [aleph.http :as aleph]
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [defn-spec.core :refer [defn-spec]]))

(s/def ::port pos-int?)
(s/def ::config (s/keys :opt-un [::port]))

(defrecord HttpServer [config handler server]
  c/Lifecycle
  (start [this]
    (let [handler (or (:handler handler) handler)
          server (aleph/start-server handler config)]
      (assoc this :server server)))
  (stop [this]
    (when server (.close server))
    (assoc this :server nil)))

(defn-spec new-http-server
  {::s/args (s/cat :config ::config)}
  [config]
  (map->HttpServer {:config (merge {:port 8080} config)}))
