(ns {{name}}.document.{{model}}.admin-resource
    (:use [clj.faris.qed.resource.admin :only [admin-get-list-resource
                                               admin-get-one-by-slug-resource
                                               admin-put-one-by-slug-resource
                                               admin-delete-one-by-slug-resource
                                               admin-post-one-resource]]
          [clj.faris.qed.util :only [get-db]]
          [liberator.core :only [defresource]]
          [{{name}}.core :only [app-state]]))

(defresource admin-get-list-{{model}}
  (get-list-resource (get-db app-state)
                     {{model}}->jsonable "{{model}}"))

(defresource admin-get-one-{{model}}-by-slug
  [slug]
  (get-one-by-slug-resource (get-db app-state)
                            {{model}}->jsonable "{{model}}"))

(defresource admin-put-one-{{model}}-by-slug
  [slug]
  (put-one-by-slug-resource (get-db app-state)
                            {{model}}->saveable
                            {{modell}}-validator
                            slug))

(defresource admin-delete-one-{{model}}-by-slug
  [slug]
  (delete-one-by-slug-resource (get-db app-state)
                               "{{model}}" slug))

(defresource admin-post-one-{{model}}-by-slug
  (post-one-resource (get-db app-state)
                     {{model}}->jsonable
                     {{model}}->saveable
                     {{model}}-validator
                     "{{model}}"))
