(ns clj.faris.qed.resource.admin
  (:use [clj.faris.qed.resource normal components]))

(defn admin-get-list-resource
  [db-instance mapper coll-name]
  (merge admin-auth
         (get-list-resource db-instance mapper coll-name)))

(defn admin-get-one-by-id-resource
  [db-instance mapper coll-name id]
  (merge admin-auth
         (get-one-by-id-resource db-instance mapper coll-name id)))

(defn admin-get-one-by-slug-resource
  [db-instance mapper coll-name slug]
  (merge admin-auth
         (get-one-by-slug-resource db-instance mapper coll-name slug)))

(defn admin-put-one-by-id-resource
  [db-instance mapper validator coll-name id]
  (merge admin-auth
         (put-one-by-id-resource db-instance
                                 mapper
                                 coll-name
                                 id)))

(defn admin-put-one-by-slug-resource
  [db-instance mapper validator coll-name slug]
  (merge admin-auth
         (put-one-by-slug-resource db-instance
                                   mapper
                                   coll-name
                                   slug)))

(defn admin-delete-one-by-id-resource
  [db-instance coll-name id]
  (merge admin-auth
         (delete-one-by-id-resource db-instance coll-name id)))

(defn admin-delete-one-by-slug-resource
  [db-instance coll-name slug]
  (merge admin-auth
         (delete-one-by-slug-resource db-instance coll-name id)))

(defn admin-post-one-resource
  [db-instance jsonable-mapper saveable-mapper validator coll-name]
  (merge admin-auth
         (post-one-resource db-instance
                            jsonable-mapper
                            saveable-mapper
                            validator
                            coll-name)))
