(ns clj.faris.qed.document.util
  (:require [clj.faris.qed.util :as u]))

(defn auto-now-field
  [value current-map]
  (if (nil? value) (u/now) value))

(defn auto-slug-field
  ([field-name value current-map]
     (let [from-field (field-name current-map)]
       (if (and (nil? value)
                (not (nil? from-field)))
         (u/slugify from-field)
         value)))
  ([value current-map]
     (auto-slug-field :name value current-map)))

(defn auto-deleted-field
  [value current-map]
  (if (nil? value)
    false
    value))

(defn auto-to-oid
  [value current-map]
  (let [v (u/try-to-oid value)]
    (if (nil? v)
      (u/oid)
      v)))

(defn auto-to-str
  [value current-map]
  (str value))
