(ns clj.faris.qed.auth.core
  (:require [remvee.base64 :as base64]))

(defn logged-in?
  [request]
  (not (nil? (-> request :cookies :__ID__))))

(defn ->user-collection
  [users]
  (when (and (and (coll? users)
                  (not (map? users)))
             (seq users)
             (map? (first users))
             (contains? (first users) :email))
    (reduce (fn [p n] (into p {(:email n) n})) {} users)))

(defn ->user-cookie-key
  [user]
  (when (and (map? user) (contains? user :email))
    (let [email (:email user)
          divider "^"
          password (:password user)
          concat-ed (str email divider password)
          base64-ed (base64/encode-str concat-ed)]
      base64-ed)))

(defn ->user-cookie
  [users]
  (when-not (or (nil? users) (empty? users))
    (reduce (fn [p n] (into p {(->user-cookie-key n) n})) {} users)))

(def user-cookie-state (atom {}))

(defn add-user-cookie!
  [user-cookie]
  (when (and (map? user-cookie) (seq user-cookie))
    (swap! user-cookie-state into user-cookie)))

(defn extract-user-info
  [request]
  (if (map? request)
    (let [user (-> request
                   :session
                   :cemerick.friend/identity
                   :authentications)
          new-request (if-not (nil? user)
                        (-> request
                            (assoc :user user))
                        request)]
      new-request)
    {}))

(defn user-cookie->user-data
  [user-cookie]
  (get @user-cookie-state user-cookie))

(defn user-data->auth-header-value
  [{:keys [username password]}]
  (if (and (string? username)
           (string? password))
    (->> (str username ":" password)
         base64/encode-str
         (str "Basic "))
    ""))
