(ns clj.faris.qed.system.server
  (:require [clj.faris.qed.util :as util])
  (:use [org.httpkit.server :only [run-server]]))

(defn -construct-key
  [& args]
  (->> args
       (filter #(not (nil? %)))
       (map #(-> % str keyword))
       vec))

(defn -construct-server-key
  [profile-name host port]
  (-construct-key "server" profile-name host port))

(defn start-server!
  [state app-routes {:keys [host port name] :as opts}]
  (let [path (-construct-server-key name host port)
        server-instance (get-in @state path)]
    (when (nil? server-instance)
      (swap! state (fn [current-state]
                            (assoc-in current-state
                                      path
                                      (run-server app-routes opts)))))))

(defn stop-server!
  [state {:keys [host port name]}]
  (let [path (-construct-server-key name host port)
        server-instance (get-in @state path)]
    (when-not (nil? server-instance)
      (swap! state (fn [current-state]
                            (let [server (get-in current-state path)
                                  _ (server :timeout 100)]
                              (util/dissoc-in current-state path)))))))
