(ns clj.faris.qed.system.mongo.db-io
  (:require [monger [collection :as mc]
                    [query :as mq]
                    [operators :as mo]]
            [clj.faris.qed.util :as util])
  (:import com.mongodb.DB))

(defprotocol Database
  (find-one-by-slug [self coll-name slug fields]
                    [self coll-name slug])
  (find-all [self coll-name kwargs opts]
            [self coll-name kwargs])
  (remove-by-slug [self coll-name slug])
  (update-by-slug [self coll-name slug kwargs])
  (find-all-by-oids [self coll-name oids kwargs opts]
                    [self coll-name oids kwargs])
  (find-all-by-slugs [self coll-name slugs kwargs opts]
                     [self coll-name slugs kwargs]) )

(def -basic-configuration
  {:page 0
   :per-page 0
   :order 1
   :fields []})

(defn- parse-page
  [value]
  (if (and (number? value)
           (or (zero? value) (pos? value)))
    value 0))

(defn- parse-order
  [order]
  (if (or (= order 1) (= order -1)) order 1))

(defn- parse-fields
  [fields]
  (if (vector? fields) fields []))

(extend-protocol Database
  DB
  (find-one-by-slug ([self coll-name slug fields]
                       (mc/find-one-as-map self coll-name {:slug slug} fields))
                    ([self coll-name slug]
                       (find-one-by-slug self coll-name slug [])))
  (find-all ([self coll-name kwargs {:keys [page per-page order fields]}]
               (let [page (parse-page page)
                     per-page (parse-page per-page)
                     order (parse-order order)
                     fields (parse-fields fields)
                     result (mq/with-collection self coll-name
                              (mq/find kwargs)
                              (mq/fields fields)
                              (mq/sort {:_id order})
                              (mq/paginate :page page :per-page per-page))]
                 result))
            ([self coll-name kwargs]
               (find-all self coll-name kwargs -basic-configuration)))
  (remove-by-slug [self coll-name slug]
    (mc/remove self coll-name {:slug slug}))
  (update-by-slug [self coll-name slug kwargs]
    (mc/update self coll-name {:slug slug} kwargs))
  (find-all-by-slugs ([self coll-name slugs [{:keys [page per-page order fields]}]]
                        (let [page (parse-page page)
                              per-page (parse-page per-page)
                              order (parse-order order)
                              fields (parse-fields fields)
                              result (mq/with-collection self coll-name
                                       (mq/find {:slug {mo/$in slugs}})
                                       (mq/fields fields)
                                       (mq/sort {:_id order})
                                       (mq/paginate :page page :per-page per-page))]
                          result))
                     ([self coll-name slugs]
                        (find-all-by-slugs self coll-name slugs -basic-configuration))))
