(ns clj.faris.qed.system.mongo.db
  (:require [monger [core :as mg]]
            [clj.faris.qed.util :as util])
  (:import com.mongodb.DB))

(defn- construct-key
  [& args]
  (->> args
       (filter #(not (nil? %)))
       (map #(-> % str keyword))
       vec))

(defn- construct-connection-key
  [profile-name host port]
  (construct-key "db" profile-name host port "connection"))

(defn- construct-db-key
  [profile-name host port db-name]
  (construct-key "db" profile-name host port "db" db-name))

(defn- start-db-connection!
  [state {:keys [host port name]}]
  (let [path (construct-connection-key name host port)
        connection-instance (get-in @state path)]
    (when (nil? connection-instance)
      (swap! state (fn [current-state]
                     (assoc-in current-state path (mg/connect {:host host
                                                               :port port})))))))

(defn start-db!
  [state {:keys [host port db-name name] :as opts}]
  (let [_ (start-db-connection! (select-keys opts [:host :port]))
        connection-path (construct-connection-key name host port)
        connection-instance (get-in @state connection-path)
        db-path (construct-db-key name host port db-name)
        db-instance (get-in @state db-path)]
    (when (nil? db-instance)
      (swap! state (fn [current-state]
                     (assoc-in current-state
                               db-path
                               (mg/get-db connection-instance db-name)))))))

(defn stop-db!
  [state {:keys [host port name]}]
  (let [path (construct-connection-key name host port)
        connection-instance (get-in @state path)]
    (when-not (nil? connection-instance)
      (swap! state (fn [current-state]
                     (let [conn (get-in current-state path)
                           _ (mg/disconnect conn)]
                       (util/dissoc-in current-state path)))))))
