(ns clj.faris.qed.server
  (:require [clj.faris.qed.util :as util])
  (:use [org.httpkit.server :only [run-server]]))

(defn- construct-key
  [& args]
  (->> args
       (map #(-> % str keyword))
       vec))

(defn- construct-server-key
  [profile-name host port]
  (construct-key profile-name host port))

(defn start-server!
  [server-state app-routes {:keys [host port name] :as opts}]
  (let [path (construct-server-key name host port)
        server-instance (get-in @server-state path)]
    (when (nil? server-instance)
      (swap! server-state (fn [current-state]
                            (assoc-in current-state
                                      path
                                      (run-server app-routes opts)))))))

(defn stop-server!
  [server-state {:keys [host port name]}]
  (let [path (construct-server-key name host port)
        server-instance (get-in @server-state path)]
    (when-not (nil? server-instance)
      (swap! server-state (fn [current-state]
                            (let [server (get-in current-state path)
                                  _ (server :timeout 100)]
                              (util/dissoc-in current-state path)))))))
