(ns clj.faris.qed.util)

(defn vec-remove
  [coll pos]
  (if (and (vector? coll)
           (number? pos)
           (contains? coll pos))
    (vec (concat (subvec coll 0 pos) (subvec coll (inc pos))))
    coll))

(defn contains-in [m ks]
  (let [not-found (Object.)]
    (not-any? #{not-found}
              [(get-in m ks not-found)])))

(defn dissoc-in
  [m ks]
  (let [ks (vec ks)
        contains-in? (contains-in m ks)]
    (if contains-in?
      (if (contains? ks 1)
        (let [update-key (pop ks)
              last-key (last ks)]
          (update-in m update-key (fn [current-m last-k]
                                    (if (vector? current-m)
                                      (vec-remove current-m last-k)
                                      (dissoc current-m last-k))) last-key))
        (dissoc m (first ks)))
      m)))
