(ns clj.faris.qed.auth.middleware
  (:require [clj.faris.qed.auth.core :as ac]))

(defn- add-user-cookie-middleware!
  [handler]
  (fn [request]
    (let [user-cookie (-> request :user-state :cookies)
          _ (ac/add-user-cookie! user-cookie)]
      (handler request))))

(defn- user-transform-middleware
  [handler]
  (fn [request]
    (let [users (:users request)
          user-collection (ac/->user-collection users)
          user-cookie (ac/->user-cookie users)
          new-request (if (or (nil? user-collection)
                              (nil? user-cookie))
                        request
                        (assoc request :user-state {:collection user-collection
                                                    :cookies user-cookie}))]
      (handler new-request))))

(defn- user->cookie-middleware
  [handler]
  (fn [request]
    (let [user (:user request)
          response (handler request)
          new-response (if (and (not (ac/logged-in? request))
                                (not (nil? user)))
                         (assoc-in response
                                   [:cookies :__ID__]
                                   (ac/->user-cookie-key user))
                         response)]
      new-response)))

(defn- user-cookie->auth-header-middleware
  [handler]
  (fn [request]
    (let [cookie (-> request :cookies :__ID__)
          new-request (if (ac/logged-in? request)
                        (->> cookie
                             ac/user-cookie->user-data
                             ac/user-data->auth-header-value
                             (assoc-in request [:headers "authorization"]))
                        request)]
      (handler new-request))))

(defn- cookie-as-bank-middleware
  [handler]
  (fn [request]
    (let [users (:users request)
          cookie (-> request :cookies :__ID__)
          new-users (if (and (ac/logged-in? request)
                             (nil? users))
                      [(ac/user-cookie->user-data cookie)]
                      [])
          new-request (assoc request :users new-users)]
      (handler new-request))))

(defn email->username-middleware
  [handler]
  (fn [request]
    (let [email (-> request :params :email)
          new-request (assoc-in request [:params :username] email)]
      (handler new-request))))

;; dipake abis friend-middleware
(defn extract-user-info-middleware
  [handler]
  (fn [request]
    (-> request
        ac/extract-user-info
        handler)))

(defn user-bank-middleware
  [handler]
  (-> handler
      add-user-cookie-middleware!
      user-transform-middleware
      cookie-as-bank-middleware
      user-cookie->auth-header-middleware
      email->username-middleware
      user->cookie-middleware))
