(ns clj.faris.qed.auth.core
  (:require [crypto.password.scrypt :as hashing]
            [remvee.base64 :as base64]))

(defn logged-in?
  [request]
  (not (nil? (-> request :cookies :__ID__))))

(defn ->user-collection
  [users]
  (when-not (or (nil? users) (empty? users))
    (reduce (fn [p n] (into p {(:email n) n})) {} users)))

(defn ->user-cookie-key
  [user]
  (let [email (:email user)
        divider "^"
        time (java.util.Date.)
        concat-ed (str email divider time)
        hash-ed (hashing/encrypt concat-ed)]
    hash-ed))

(def user-cookie-state (atom {}))

(defn add-user-cookie!
  [user-cookie]
  (when-not (nil? user-cookie)
    (swap! user-cookie-state into user-cookie)))

(defn ->user-cookie
  [users]
  (when-not (or (nil? users) (empty? users))
    (reduce (fn [p n] (into p {(->user-cookie-key n) n})) {} users)))

;; authentication
(defn extract-user-info
  [request]
  (let [user (-> request
                 :session
                 :cemerick.friend/identity
                 :authentications)
        new-request (if-not (nil? user)
                      (-> request
                          (assoc :user user)
                          (dissoc :session))
                      request)]
    new-request))

(defn user-cookie->user-data
  [user-cookie]
  (get user-cookie-state user-cookie-state))

(defn user-data->auth-header-value
  [{:keys [username password]}]
  (->> (str username ":" password)
       base64/encode-str
       (str "Basic ")))
