(ns clj.faris.qed.validator.core
  (:use [clj.faris.qed.validator.rule :only [process-rule]]))

(defn- should-validate?
  [value rule]
  (let [force? (-> rule meta :force?)
        value-nil? (nil? value)]
    (or (not value-nil?) (and force? value-nil?))))

(defn- do-validate
  [validate? value rule]
  (when (and validate? (not (rule value)))
    ((-> rule meta :message) value)))

(defn- validate-one-field-inner
  [value rules]
  (first (reduce (fn [container rule]
                   (let [validate? (should-validate? value rule)
                         validation-result (do-validate validate? value rule)
                         final-result (if (nil? validation-result)
                                        container
                                        (conj container validation-result))]
                     final-result)) [] rules)))

(defn- validate-one-field-outer
  [map-rules map-value k]
  (let [value (k map-value)
        rules (k map-rules)
        result (validate-one-field-inner value (map process-rule rules))]
    (when-not (nil? result)
      {k result})))

(defn -validate-all-field
  [map-rules map-value]
  (let [validation-fn (partial validate-one-field-outer map-rules map-value)
        ks (keys map-rules)
        result (reduce (fn [container k]
                         (let [inner-result (validation-fn k)
                               new-container (into container inner-result)]
                           new-container)) {} ks)]
    result))

(defn- validate-strict-inner
  [map-rules k]
  (when (not (contains? map-rules k)) [k]))

(defn -validate-strict
  [map-rules map-value]
  (let [validation-fn (partial validate-strict-inner map-rules)
        ks (keys map-value)
        result (reduce (fn [container k]
                         (let [inner-result (validation-fn k)
                               new-container (into container inner-result)]
                           new-container)) [] ks)]
    result))

(defmacro defvalidator
  [name & args]
  (let [default-settings {:strict? true}
        [docstring args] (if (-> args first string?)
                           [(first args) (next args)]
                           [nil args])
        [settings args] (if (-> args first map?)
                          [(into default-settings (first args)) (next args)]
                          [default-settings args])]
    `(do
       (def ~name
         (with-meta
           (fn [map-value#]
             (if-not (map? map-value#)
               {:self (str "Value is " map-value# ". " "It should be a map.")}
               (let [empty-checker# (fn [value#]
                                     (when-not (empty? value#)
                                       value#))
                     map-rules# (hash-map ~@args)
                     normal-validation-result# (-validate-all-field map-rules# map-value#)]
                 (if-not (:strict? ~settings)
                   (empty-checker# normal-validation-result#)
                   (let [strict-validation-result# (-validate-strict map-rules# map-value#)
                         final-result# (if-not (empty? strict-validation-result#)
                                         (assoc normal-validation-result# :strict strict-validation-result#)
                                         normal-validation-result#)]
                     (empty-checker# final-result#))))))
           ~settings))
       (alter-meta! (var ~name)
                    assoc
                    :doc ~docstring
                    :arglists '([m])))))
