(ns clj.faris.qed.mapper)

(defn- should-map?
  [map-func-meta map-value k]
  (or (contains? map-value k) (-> map-func-meta k true?)))

(defn- go-change-value
  [map-func map-value k]
  (let [func (k map-func)
        value (k map-value)
        new-value (func value map-value)]
    new-value))

(defmacro defmapper
  [name & args]
  (let [[docstring args] (if (-> args first string?)
                           [(first args) (next args)]
                           [nil args])
        [settings args] (if (-> args first map?)
                          [(first args) (next args)]
                          [nil args])]
    `(do
       (def ~name
         (with-meta
           (fn [map-value#]
             (let [map-func# (hash-map ~@args)
                   keys-being-used-to-map# (keys map-func#)
                   should-map?# (partial should-map? ~settings map-value#)
                   mapper-fn# (partial go-change-value map-func# map-value#)
                   result# (reduce (fn [container# k#]
                                     (let [should-apply-func?# (should-map?# k#)
                                           inner-result# (if should-apply-func?#
                                                           (assoc container# k# (mapper-fn# k#))
                                                           container#)]
                                       inner-result#)) map-value# keys-being-used-to-map#)]
               result#))
           ~settings))
       (alter-meta! (var ~name)
                    assoc
                    :doc ~docstring
                    :arglists '([~@args])))))
