(defproject farbetter/utils "0.1.64"
  :description "Various utilities"
  :url "https://github.com/farbetter/utils"
  :license {:name "Apache License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0"}
  :lein-release {:scm :git
                 :deploy-via :clojars}

  :pedantic? :abort

  :deploy-repositories [["clojars" {:creds :gpg}]]

  :profiles {:dev
             {:global-vars {*warn-on-reflection* true}
              :plugins
              [[lein-ancient "0.6.10"]
               [lein-cljsbuild "1.1.7"]
               ;; Because of confusion with a defunct project also called
               ;; lein-release, we exclude lein-release from lein-ancient.
               [lein-release "1.0.9"
                :upgrade false :exclusions [org.clojure/clojure]]]}}

  :dependencies
  [[cljsjs/bytebuffer "5.0.1-0"]
   [cljsjs/long "3.0.3-1"]
   [cljsjs/nodejs-externs "1.0.4-1"]
   [cljsjs/pako "0.2.7-0"]
   [cljs-http "0.1.43"]
   [clj-time "0.14.0"]
   [com.andrewmcveigh/cljs-time "0.5.1"]
   [com.cognitect/transit-clj "0.8.300"]
   [com.cognitect/transit-cljs "0.8.239"]
   [com.google.guava/guava "23.0" :exclusions [com.google.code.findbugs/jsr305]]
   [com.taoensso/timbre "4.10.0"]
   [danlentz/clj-uuid "0.1.7"]
   [fipp "0.6.10"]
   [http-kit "2.2.0"]
   [mvxcvi/puget "1.0.1"]
   [org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.9.908"]
   [org.clojure/core.async "0.3.443" :exclusions [org.clojure/tools.reader]]
   [prismatic/schema "1.1.6"]]

  :test-selectors {:default (constantly true)
                   :the-one :the-one}

  :repl-options
  {:init-ns farbetter.utils}

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true}}
    {:id "node-test-adv"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_adv/test_main.js"]
     :compiler
     {:optimizations :advanced
      :main "farbetter.test-runner"
      :target :nodejs
      :static-fns true
      :output-to  "target/test/node_test_adv/test_main.js"
      :output-dir "target/test/node_test_adv"
      :source-map "target/test/node_test_adv/map.js.map"}}
    {:id "node-test-simple"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_simple/test_main.js"]
     :compiler
     {:optimizations :simple
      :main "farbetter.test-runner"
      :target :nodejs
      :static-fns true
      :output-to  "target/test/node_test_simple/test_main.js"
      :output-dir "target/test/node_test_simple"
      :source-map "target/test/node_test_simple/map.js.map"}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "auto-test-cljs-adv" ["do"
                         "clean,"
                         "cljsbuild" "auto" "node-test-adv"]
   "auto-test-cljs-simple" ["do"
                            "clean,"
                            "cljsbuild" "auto" "node-test-simple"]})
