(defproject farbetter/utils "0.1.50"
  :description "Various utilities"
  :url "https://github.com/farbetter/utils"
  :license {:name "Apache License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0"}
  :plugins
  [;; Because of confusion with a defunct project also called
   ;; lein-release, we exclude lein-release from lein-ancient.
   [lein-release "1.0.9" :upgrade false :exclusions [org.clojure/clojure]]]

  :lein-release {:scm :git
                 :deploy-via :clojars}
  :deploy-repositories [["clojars" {:creds :gpg}]]

  :profiles {:dev
             {:plugins
              [[lein-cljsbuild "1.1.3"]]}}

  :dependencies
  [[cljsjs/bytebuffer "5.0.1-0"]
   [cljsjs/long "3.0.3-1"]
   [cljsjs/nodejs-externs "1.0.4-1"]
   [cljsjs/pako "0.2.7-0"]
   [cljs-http "0.1.41"]
   [clj-time "0.12.0"]
   [com.andrewmcveigh/cljs-time "0.4.0"]
   [com.cognitect/transit-clj "0.8.288"]
   [com.cognitect/transit-cljs "0.8.239"]
   [com.google.guava/guava "19.0"]
   [com.taoensso/timbre "4.7.3"]
   [danlentz/clj-uuid "0.1.6"]
   [fipp "0.6.6"]
   [http-kit "2.2.0"]
   [mvxcvi/puget "1.0.0"]
   [org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.9.93"]
   [org.clojure/core.async "0.2.385" :exclusions [org.clojure/tools.reader]]
   [prismatic/schema "1.1.3"]]

  :repl-options
  {:init-ns farbetter.utils}

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true}}
    {:id "node-test-adv"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_adv/test_main.js"]
     :compiler
     {:optimizations :advanced
      :main "farbetter.test-runner"
      :target :nodejs
      :static-fns true
      :output-to  "target/test/node_test_adv/test_main.js"
      :output-dir "target/test/node_test_adv"
      :source-map "target/test/node_test_adv/map.js.map"}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "auto-test-cljs-adv" ["do"
                         "clean,"
                         "cljsbuild" "auto" "node-test-adv"]})
