(defproject farbetter/utils "0.1.32"
  :description "Various utilities"
  :url "https://github.com/farbetter/utils"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :lein-release {:scm :git
                 :deploy-via :clojars}
  :deploy-repositories [["clojars" {:creds :gpg}]]

  :profiles {:dev
             {:plugins [[lein-cljsbuild "1.1.1"]
                        [lein-release "1.0.9"]]}}

  :dependencies
  [[cljsjs/long "3.0.1-1"]
   [cljsjs/nodejs-externs "1.0.4-1"]
   [clj-time "0.11.0"]
   [com.andrewmcveigh/cljs-time "0.4.0"]
   [com.cognitect/transit-clj "0.8.285"]
   [com.cognitect/transit-cljs "0.8.237"]
   [com.google.guava/guava "19.0"]
   [com.taoensso/timbre "4.2.1"]
   [danlentz/clj-uuid "0.1.6"]
   [mvxcvi/puget "1.0.0"]
   [org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.7.228"]
   [org.clojure/core.async "0.2.374"]
   [prismatic/schema "1.0.4"]]

  :repl-options
  {:init-ns farbetter.utils}

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true}}
    {:id "node-test-adv"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_adv/test_main.js"]
     :compiler
     {:optimizations :advanced
      :externs ["externs.js"]
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to  "target/test/node_test_adv/test_main.js"
      :output-dir "target/test/node_test_adv"
      :source-map "target/test/node_test_adv/map.js.map"}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "auto-test-cljs-adv" ["do"
                         "clean,"
                         "cljsbuild" "auto" "node-test-adv"]})
