(ns farbetter.utils)

;;;;;;;;;;; Environment variables

(defn construct-java-type-from-str [klass str]
  (.newInstance
   (.getConstructor klass (into-array java.lang.Class [java.lang.String]))
   (object-array [str])))

(defn construct-from-str [var-type var-value]
  (if (= clojure.lang.Keyword var-type)
    (keyword var-value)
    (construct-java-type-from-str var-type var-value)))

(defn get-env-var
  ([var-name var-type default-value]
   (if-let [var-value-str (System/getenv var-name)]
     (construct-from-str var-type var-value-str)
     default-value))

  ([var-name var-type]
   (if-let  [var-value (get-env-var var-name var-type nil)]
     var-value
     (throw
      (ex-info
       "environment variable not found"
       {:type :env-var-not-found :var-name var-name :var-type var-type})))))

;;;;;;;;;;; Exception handling

(defmacro throw-far-error [description error-type error-subtype error-map]
  `(let [emap# (merge ~error-map
                      {:type ~error-type :subtype ~error-subtype})]
     (throw (ex-info (str ~description ". error-map: " emap#)
                     emap#))))
