(defproject farbetter/utils "0.1.17"
  :description "Various utilities"
  :url "https://github.com/farbetter/utils"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :plugins [[lein-release "1.0.9"]]
  :lein-release {:scm :git
                 :deploy-via :clojars}
  :deploy-repositories [["clojars" {:creds :gpg}]]

  :profiles {:dev
             {:plugins [[lein-cljsbuild "1.1.0"]]}}

  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/clojurescript "1.7.48"]
                 [mvxcvi/puget "0.8.1"]]

  :repl-options
  {:init-ns farbetter.utils}

  :cljsbuild
  {:builds
   [{:id "node-dev"
     :source-paths ["src" "test"]
     :notify-command ["node" "dev-resources/run.js"]
     :compiler
     {:optimizations :none
      :target :nodejs
      :output-to "target/test/node_dev/test_main.js"
      :output-dir "target/test/node_dev"
      :source-map true}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-dev"]})
