(ns farbetter.utils)

(defn construct-java-type-from-str [klass str]
  (.newInstance
   (.getConstructor klass (into-array java.lang.Class [java.lang.String]))
   (object-array [str])))

(defn construct-from-str [var-type var-value]
  (if (= clojure.lang.Keyword var-type)
    (keyword var-value)
    (construct-java-type-from-str var-type var-value)))

(defn get-env-var [var-name var-type default-value]
  (if-let [var-value-str (System/getenv var-name)]
    (construct-from-str var-type var-value-str)
    default-value))

