(defproject farbetter/string-store "0.1.0"
  :description "A versioned large-string store"
  :url "https://github.com/farbetter/string-store"
  :license {:name "The Apache Software License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0.txt"}
  :lein-release {:scm :git
                 :deploy-via :clojars}

  :profiles
  {:dev
   {:plugins
    [[lein-cljsbuild "1.1.4"]
     ;; Because of confusion with a defunct project also called
     ;; lein-release, we exclude lein-release from lein-ancient.
     [lein-release "1.0.9" :upgrade false :exclusions [org.clojure/clojure]]]}}

  :dependencies
  [[com.amazonaws/aws-java-sdk-dynamodb "1.11.37"
    :exclusions [com.fasterxml.jackson.dataformat/jackson-dataformat-cbor
                 commons-codec commons-logging joda-time]]
   [com.taoensso/timbre "4.7.4"]
   [commons-logging "1.2"]
   [farbetter/roe "0.1.17"]
   [farbetter/utils "0.1.57"]
   [org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.9.229"]
   [org.clojure/core.async "0.2.391"]
   [prismatic/schema "1.1.3"]]

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]}

  :test-selectors {:default (complement :integration)
                   :integration :integration
                   :the-one :the-one
                   :all (constantly true)})
