(ns farbetter.string-store
  (:refer-clojure :exclude [load-string])
  (:require
   [farbetter.string-store.impl :as impl]
   [farbetter.string-store.storage :as storage]
   [farbetter.utils :as u :refer [sym-map]]
   [schema.core :as s]
   [taoensso.timbre :as timbre :refer [debugf errorf infof tracef warnf]]))

(s/defn get-version :- u/Channel
  [storage :- storage/Storage
   name :- s/Str]
  (storage/get-version storage name))

(s/defn load-string :- u/Channel
  ([storage :- storage/Storage
    name :- s/Str]
   (impl/load-string* storage name nil))
  ([storage :- storage/Storage
    name :- s/Str
    version :- s/Num]
   (impl/load-string* storage name version)))

(s/defn store-string :- u/Channel
  ([storage :- storage/Storage
    name :- s/Str
    s :- s/Str]
   (impl/store-string* storage name nil s))
  ([storage :- storage/Storage
    name :- s/Str
    version :- s/Num
    s :- s/Str]
   (impl/store-string* storage name version s)))
