# roe

## An [Apache Avro](http://avro.apache.org/docs/current/) library for Clojure and Clojurescript

### Installation via Leiningen
![Clojars Project](http://clojars.org/farbetter/roe/latest-version.svg)

### Supports:
* All Avro data types
  * [Privitive types] (http://avro.apache.org/docs/1.7.7/spec.html#schema_primitive)
  * [Complex types] (http://avro.apache.org/docs/1.7.7/spec.html#schema_complex)
* [Schema evolution] (http://avro.apache.org/docs/1.7.7/spec.html#Schema+Resolution)
* Recursive schemas
* Binary encoding/decoding
* String encoding/decoding
* EDN for declaring schemas (conversion to/from JSON is also supported)

### Differences from the [official Avro spec] (http://avro.apache.org/docs/1.7.7/spec.html)
* In schemas:
  * EDN is used instead of JSON
  * All names, types, and keys are keywords, not strings
  * Avro maps (not records) must have string keys, however
  * All record fields must have a default specified
  * For record fields with type :long, the default must fit in an integer
  * The :order field of record fields is currently ignored
  * Namespaces are not supported.
  * Dotted names (e.g. :my-ns.my-name) are supported
* Promotion from bytes to string is not supported. This is allowed by the spec, but would result in invalid strings in many cases. Promotion from string to bytes is supported.
* Serialized objects are limited to 1 million bytes
* Parsing Canonical Form uses bencode instead of JSON
* In EDN data to be serialized, all names and keys must be keywords
* In deserialization, all names and keys are converted to keywords
* When converting keywords to strings, hypens are replaced with underscores
* When converting strings to keywords, underscores are replaced with hypens
* Avro protocols are not currently supported
* Object container files are not currently supported

### Usage
TBD


### License

Copyright © 2015 FarBetter, Inc.

Distributed under the Apache License 2.0: http://www.apache.org/licenses/LICENSE-2.0.txt
