(ns farbetter.roe.test-helpers
  (:require
   [farbetter.roe :as r]
   [farbetter.roe.utils :as ru]
   #?(:clj [farbetter.utils :refer [inspect]]))
  #?(:cljs
     (:require-macros
      [farbetter.utils :as u :refer [inspect]])))

(defn round-trip? [schema edn]
  (let [encoded (r/edn->avro-b64-string schema edn)
        decoded (r/avro-b64-string->edn schema schema encoded)
        eq? (ru/equivalent? schema edn schema decoded)]
    (when-not eq?
      (println "#################### round-trip? failed ####################")
      (inspect schema edn decoded))
    eq?))
