(ns farbetter.roe.json
  (:require
   #?(:clj  [cheshire.core :as cheshire]
            :cljs [goog.json :as json])
   [farbetter.roe.schemas :refer [AvroSchema]]
   [farbetter.roe.serdes :as serdes]
   [farbetter.roe.transform :refer [transform-schema]]
   [farbetter.utils :refer [throw-far-error #?@(:clj [inspect sym-map])]]
   [schema.core :as s :include-macros true])
  #?(:cljs
     (:require-macros
      [farbetter.utils :refer [inspect sym-map]])))

(s/defn edn->json :- s/Str
  [edn :- s/Any]
  #?(:clj
     (cheshire/generate-string edn)
     :cljs
     (json/serialize (clj->js edn))))

(s/defn json->edn :- s/Any
  [s :- s/Any]
  #?(:clj
     (cheshire/parse-string s)
     :cljs
     (-> (json/parse s)
         (js->clj))))

(s/defn edn-schema->json :- s/Str
  [schema :- AvroSchema]
  (serdes/valid-schema? schema)
  (-> (transform-schema schema :encode false)
      (edn->json)))

(s/defn json->edn-schema :- AvroSchema
  [s :- s/Str]
  (-> (json->edn s)
      (transform-schema :decode false)))
