(ns farbetter.roe.test-helpers
  (:require
   [farbetter.roe :as r]
   [farbetter.roe.utils :as ru]
   #?(:clj [farbetter.utils :refer [inspect]])
   [taoensso.timbre :as timbre
    #?(:clj :refer :cljs :refer-macros) [debugf errorf infof]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :as u :refer [inspect]])))

(defn round-trip? [schema edn]
  (let [encoded (r/edn->avro-b64-string schema edn)
        decoded (r/avro-b64-string->edn schema schema encoded)
        eq? (ru/equivalent? schema edn schema decoded)]
    (when-not eq?
      (errorf (str "######## round-trip? failed #########.\n     schema: %s\n"
                   "     edn: %s\n     decoded: %s")
              schema edn decoded))
    eq?))
