(defproject farbetter/roe "0.1.1"
  :description "A Clojure/Clojurescript wrapper for Avro"
  :url "https://github.com/farbetter/roe"
  :license {:name "The Apache Software License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0.txt"}
  :lein-release {:scm :git
                 :deploy-via :clojars}
  :profiles
  {:dev {:plugins [[lein-cljsbuild "1.1.1"]
                   [lein-release "1.0.9"]]}}

  :dependencies
  [[cheshire "5.5.0"]
   [cljsjs/bytebuffer "5.0.0-1"]
   [cljsjs/long "3.0.1-1"]
   [cljsjs/nodejs-externs "1.0.4-1"]
   [com.google.guava/guava "19.0"]
   [com.taoensso/timbre "4.1.4"]
   [farbetter/utils "0.1.30"]
   [org.clojure/clojure "1.7.0"]
   [org.clojure/clojurescript "1.7.170"]
   [org.clojure/test.check "0.9.0"]
   [prismatic/schema "1.0.4"]]

  :jvm-opts ^:replace ["-server" "-XX:+AggressiveOpts"]

  ;; Enable this to check for reflection problems
  ;; :global-vars {*warn-on-reflection* true}

  :test-selectors {:default (complement :perf)
                   :perf :perf
                   :the-one :the-one
                   :all (constantly true)}

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true}}
    {:id "node-perf"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_perf/test_main.js" ":all"]
     :compiler
     {:optimizations :advanced
      :target :nodejs
      :static-fns true
      :output-to "target/test/node_perf/test_main.js"
      :output-dir "target/test/node_perf"
      :source-map "target/test/node_perf/map.js.map"}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "perf-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-perf"]})
