(ns farbetter.roe.test-helpers
  (:require
   [farbetter.roe :as r]
   [farbetter.roe.utils :as ru]
   #?(:clj [farbetter.utils :refer [inspect]]))
  #?(:cljs
     (:require-macros
      [farbetter.utils :as u :refer [inspect]])))

(defn round-trip? [schema obj]
  (let [encoded (r/obj->avro-b64-string schema obj)
        decoded (r/avro-b64-string->obj schema schema encoded)
        eq? (ru/equivalent? schema obj schema decoded)]
    (when-not eq?
      (println "#################### round-trip? failed ####################")
      (inspect schema obj decoded))
    eq?))
