(ns farbetter.roe.json
  (:require
   #?(:clj  [cheshire.core :as cheshire]
            :cljs [goog.json :as json])
   [farbetter.roe.schemas :refer [AvroSchema]]
   [farbetter.roe.transform :refer [transform-schema]]
   [farbetter.utils :refer [throw-far-error #?@(:clj [inspect sym-map])]]
   [schema.core :as s :include-macros true])
  #?(:cljs
     (:require-macros
      [farbetter.utils :refer [inspect sym-map]])))

(s/defn obj->json :- s/Str
  [obj :- s/Any]
  #?(:clj
     (cheshire/generate-string obj)
     :cljs
     (json/serialize (clj->js obj))))

(s/defn json->obj :- s/Any
  [s :- s/Any]
  #?(:clj
     (cheshire/parse-string s)
     :cljs
     (-> (json/parse s)
         (js->clj))))

(s/defn ^:always-validate edn-schema->json :- s/Str
  [schema :- AvroSchema]
  (-> (transform-schema schema :encode false)
      (obj->json)))

(s/defn json->edn-schema :- AvroSchema
  [s :- s/Str]
  (-> (json->obj s)
      (transform-schema :decode false)))
