(ns farbetter.roe
  (:require
   [farbetter.roe.bencode :as bc]
   [farbetter.roe.fingerprint :as f]
   [farbetter.roe.schemas :refer [AvroData AvroFixedOrBytes AvroSchema]]
   [farbetter.roe.serdes :as serdes]
   [farbetter.roe.utils :as ru]
   [farbetter.utils :as u :refer [throw-far-error #?@(:clj [inspect sym-map])]]
   [schema.core :as s :include-macros true]
   [taoensso.timbre :as timbre
    #?(:clj :refer :cljs :refer-macros) [debugf infof warnf errorf]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :refer [inspect sym-map]])))

(s/defn obj->avro-byte-array :- AvroFixedOrBytes
  [schema :- AvroSchema
   obj :- AvroData]
  (serdes/obj->avro-byte-array schema obj))

(s/defn avro-byte-array->obj :- AvroData
  [writer-schema :- AvroSchema
   reader-schema :- AvroSchema
   avro-byte-array :- AvroFixedOrBytes]
  (serdes/avro-byte-array->obj writer-schema reader-schema avro-byte-array))

(s/defn obj->avro-b64-string :- s/Str
  [schema :- AvroSchema
   obj :- AvroData]
  (serdes/obj->avro-b64-string schema obj))

(s/defn avro-b64-string->obj :- AvroData
  [writer-schema :- AvroSchema
   reader-schema :- AvroSchema
   avro-str :- s/Str]
  (serdes/avro-b64-string->obj writer-schema reader-schema avro-str))

(s/defn edn-schema->fingerprint :- (s/pred ru/long?)
  [schema :- AvroSchema]
  ;; make-context validates the schema and throws useful exceptions if invalid
  (serdes/make-context schema)
  (let [bencoded-canonical-form (bc/edn-schema->bencode schema true)]
    (f/fingerprint64 bencoded-canonical-form)))

(s/defn valid-schema? :- s/Bool
  [schema :- AvroSchema]
  (serdes/valid-schema? schema))
