(defproject farbetter/roe "0.1.0"
  :description "A Clojure/Clojurescript wrapper for Avro"
  :url "http://www.farbetter.com"
  :license {:name "The Apache Software License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0.txt"}
  :lein-release {:scm :git
                 :deploy-via :clojars}
  :profiles
  {:dev {:plugins [[lein-cljsbuild "1.1.1"]
                   [lein-release "1.0.9"]]}}

  :dependencies
  [[cheshire "5.5.0"]
   [cljsjs/bytebuffer "5.0.0-0"]
   [cljsjs/long "3.0.1-0"]
   [cljsjs/nodejs-externs "1.0.4-1"]
   [com.google.guava/guava "18.0"]
   [com.taoensso/timbre "4.1.4"]
   [farbetter/utils "0.1.28"]
   [org.clojure/clojure "1.7.0"]
   [org.clojure/clojurescript "1.7.170"]
   [org.clojure/test.check "0.9.0"]
   [prismatic/schema "1.0.3"]]

  :jvm-opts ^:replace ["-server" "-XX:+AggressiveOpts"]

  ;; Enable this to check for reflection problems
  ;; :global-vars {*warn-on-reflection* true}

  :test-selectors {:default (complement :perf)
                   :perf :perf
                   :the-one :the-one
                   :all (constantly true)}

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true}}
    {:id "node-perf"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_perf/test_main.js" ":all"]
     :compiler
     {:optimizations :advanced
      :target :nodejs
      ;; :foreign-libs
      ;; [{:provides ["cljsjs.long"]
      ;;   :file "resources/long.js",
      ;;   :file-min "resources/long.min.js"}
      ;;  {:provides ["cljsjs.bytebuffer"]
      ;;   :file "resources/bytebuffer.js",
      ;;   :file-min "resources/bytebuffer.min.js"}]
      ;; :externs ["resources/externs/long.ext.js"
      ;;           "resources/externs/bytebuffer.ext.js"]
      :static-fns false
      :pretty-print true
      :output-to "target/test/node_perf/test_main.js"
      :output-dir "target/test/node_perf"
      :source-map "target/test/node_perf/map.js.map"
      :verbose true
      :pseudo-names true
      }}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "perf-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-perf"]})
