(ns farbetter.mu.transport
  (:require
   [#?(:clj clojure.core.async :cljs cljs.core.async) :as ca]
   [farbetter.utils :as u :refer
    [throw-far-error #?@(:clj [go-safe inspect sym-map])]]
   [farbetter.mu.state :as state]
   [farbetter.mu.utils :as mu :refer
    [command-block CommandOrCommandBlock ConnId ProcType]]
   [farbetter.roe :as roe]
   [freedomdb.schemas :refer [DBType]]
   [schema.core :as s :include-macros true]
   [taoensso.timbre :as timbre
    #?(:clj :refer :cljs :refer-macros) [debugf errorf infof]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :as u :refer [go-safe inspect sym-map]])))

(def protocol-bytes (roe/edn->avro-byte-array :int mu/protocol-version))

(s/defn connect-to-gw :- nil
   [conn-id :- ConnId
    rcv-chan :- u/Channel
    command-chan :- u/Channel
    conn-factory :- (s/=> s/Any)
    proc-type :- ProcType]
  (go-safe
   (debugf "In %s connect-to-gw. conn-id: %s" proc-type conn-id)
   (ca/put! command-chan [[:add-conn conn-id nil nil :gw]])
   (let [connection-added-ch (ca/chan 1)
         on-connect #(go-safe
                      (debugf "In %s on-connect. conn-id: %s"
                              proc-type conn-id)
                      (let [[sender closer] (ca/<! connection-added-ch)]
                        (ca/put! command-chan
                                 [(command-block
                                   [:set-sender-closer conn-id sender closer]
                                   [:set-conn-state conn-id :connected]
                                   [:send-bytes conn-id protocol-bytes])])))

         on-disconnect #(do
                          (infof (str "Connection to " conn-id " closed. "
                                      "Reason: " %))
                          (ca/put! command-chan [[:delete-conn conn-id]]))
         on-error #(do (debugf "Error: %s" %)
                       (on-disconnect %))
         on-rcv #(ca/put! rcv-chan [conn-id %])
         {:keys [sender closer]} (conn-factory conn-id on-connect on-disconnect
                                               on-error on-rcv)]
     (debugf "$$$$ %s conn-factory returned. sender: %s" proc-type sender)
     (if sender
       (ca/put! connection-added-ch [sender closer])
       (ca/put! command-chan [[:delete-conn conn-id]]))))
  nil)
