(defproject farbetter/mu "0.1.2"
  :description "A microservices framework for Clojure and Clojurescript"
  :url "https://github.com/farbetter/mu"
  :license {:name "The Apache Software License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0.txt"}
  :lein-release {:scm :git
                 :deploy-via :clojars}

  :profiles
  {:dev {:plugins [[lein-cljsbuild "1.1.3"]
                   [lein-release "1.0.9"]]}}

  :dependencies
  [[com.taoensso/timbre "4.3.1"]
   [farbetter/pete "0.1.3" :exclusions [prismatic/schema]]
   [farbetter/roe "0.1.5" :exclusions [prismatic/schema]]
   [farbetter/utils "0.1.40"]
   [farbetter/freedomdb "0.1.7"]
   [org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.8.40"]
   [org.clojure/core.async "0.2.374"]
   [stylefruits/gniazdo "0.4.1"]]

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true}}
    {:id "node-test-adv"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_adv/test_main.js"]
     :compiler
     {:optimizations :advanced
      :main "farbetter.test-runner"
      :target :nodejs
      :static-fns true
      :output-to  "target/test/node_test_adv/test_main.js"
      :output-dir "target/test/node_test_adv"
      :source-map "target/test/node_test_adv/map.js.map"}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "auto-test-cljs-adv" ["do"
                         "clean,"
                         "cljsbuild" "auto" "node-test-adv"]})
