(ns farbetter.mu.transport
  (:require
   [#?(:clj clojure.core.async :cljs cljs.core.async) :as ca]
   [farbetter.utils :as u :refer
    [throw-far-error #?@(:clj [go-safe inspect sym-map])]]
   [farbetter.mu.state :as state]
   [farbetter.mu.utils :as mu :refer [Channel ConnId]]
   [farbetter.roe :as roe]
   [freedomdb.frontend :as fdb]
   [freedomdb.schemas :refer [DBType]]
   [schema.core :as s :include-macros true]
   [taoensso.timbre :as timbre
    #?(:clj :refer :cljs :refer-macros) [debugf errorf infof]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :as u :refer [go-safe inspect sym-map]])))

(def protocol-bytes (roe/edn->avro-byte-array :int mu/protocol-version))

(s/defn connect-to-gw :- nil
  [db-atom :- (s/atom DBType)
   conn-id :- ConnId
   rcv-chan :- Channel
   conn-factory :- (s/=> s/Any)]
  (debugf "Entering connect-to-gw. conn-id: %s" conn-id)
  (state/add-conn! db-atom conn-id nil nil :gw)
  (let [connection-added-ch (ca/chan 1)
        connect (fn [db]
                  (-> db
                      (state/set-conn-state conn-id :connected)
                      (state/send-bytes conn-id protocol-bytes)))
        on-connect #(go-safe
                     (ca/<! connection-added-ch)
                     (swap! db-atom connect)
                     (infof "Connected to %s. State: %s" conn-id
                             (state/get-conn-state @db-atom conn-id)))
        on-disconnect #(do
                         (infof (str "Connection to " conn-id " closed. "
                                     "Reason: " %))
                         (state/remove-conn! db-atom conn-id))
        on-error #(do (debugf "Error: %s" %)
                      (on-disconnect %))
        on-rcv #(ca/put! rcv-chan [conn-id %])
        {:keys [sender closer]} (conn-factory conn-id on-connect on-disconnect
                                              on-error on-rcv)]
    (if sender
      (do
        (state/set-sender-closer! db-atom conn-id sender closer)
        (ca/put! connection-added-ch true))
      (state/remove-conn! db-atom conn-id))
    nil))
