(ns farbetter.mu.utils
  (:require
   [#?(:clj clojure.core.async.impl.protocols
       :cljs cljs.core.async.impl.protocols) :as cap]
   [farbetter.mu.msgs :as msgs]
   [farbetter.roe :as roe]
   [farbetter.roe.schemas :as rs]
   [farbetter.utils :as u :refer
    [throw-far-error ByteArray #?@(:clj [go-safe inspect sym-map])]]
   [freedomdb.frontend :as fdb]
   [freedomdb.schemas :refer [DBType]]
   [schema.core :as s :include-macros true]
   [taoensso.timbre :as timbre
    #?(:clj :refer :cljs :refer-macros) [debugf errorf infof]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :as u :refer [go-safe inspect sym-map]])))

(def msg-schemas
  [msgs/client-login-rq-schema msgs/client-login-rs-schema
   msgs/fingerprint-to-json-schema-schema
   msgs/keep-alive-schema msgs/rpc-rq-schema
   msgs/rq-failed-schema msgs/schema-rq-schema
   msgs/rpc-rs-schema msgs/service-instance-login-rq-schema
   msgs/service-instance-login-rs-schema])

(def valid-proc-types #{:si :cl :gw})
(def valid-ops
  #{:add-fragment :add-schema :close-conn :handle-missing-schema :inject-bytes
    :process-msg :remove-fragments :remove-waiting-bytes :send-bytes :send-login
    :send-msg :send-schema :set-conn-state})
(def protocol-version 1)
(def valid-conn-states #{:start :connected :protocol-negotiated :logged-in})
(def max-data-bytes  1e7)
(def max-fragment-bytes (* 1000 32))
(def default-rpc-timeout-ms (* 1000 10))

;;;;;;;;;;;;;;;;;;;; Schemas ;;;;;;;;;;;;;;;;;;;;

(def Op (s/pred valid-ops))
(def Command [(s/one Op "op") s/Any])
(def ConnState (s/pred valid-conn-states))
(def Fingerprint (s/pred u/long?))
(def Fragment {(s/optional-key :msg-id) s/Any
               (s/required-key :num-fragments) s/Num
               (s/required-key :fragment-num) s/Num
               (s/required-key :fingerprint) Fingerprint
               (s/required-key :fragment-data) ByteArray})
(def UUIDMap {(s/required-key :high) s/Int
              (s/required-key :midh) s/Int
              (s/required-key :midl) s/Int
              (s/required-key :low) s/Int})
(def ProcType (s/pred valid-proc-types))
(def OpToF {s/Keyword (s/=> s/Any)})
(def MsgId UUIDMap)
(def RequestId UUIDMap)
(def UserId UUIDMap)
(def ConnId s/Str)
(def Channel (s/protocol cap/Channel))

;;;;;;;;;;;;;;;;;;;; Public Fns ;;;;;;;;;;;;;;;;;;;;

(defn check-data-len [data-len]
  (when (> data-len max-data-bytes)
    (throw-far-error
     (str "Msg is too large. Msgs must be less than " max-data-bytes
          " bytes when encoded.")
     :illegal-argument :msg-too-large (sym-map data-len))))
