(ns freedomdb.test-helpers
  (:require
   [farbetter.utils :refer [#?@(:clj [inspect sym-map throws]) throw-far-error]]
   [freedomdb.frontend :as fe])
  #?(:cljs
     (:require-macros
      [farbetter.utils :refer [inspect sym-map throws]])))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Helper functions

;; Set the backend for the tests here
(def create-db #(fe/create-db :mem))

(defn populate-db [db]
  (let [t :favs]
    (-> (fe/create-table db
                         t {:name {:type :str1000
                                   :indexed true}
                            :fav-num {:type :int4
                                      :indexed true}})
        (fe/insert t {:name "Alice" :fav-num 10})
        (fe/insert t {:name "Bobby" :fav-num 10})
        (fe/insert t {:name "Clarence" :fav-num 7})
        (fe/insert t {:name "Diana" :fav-num 8})
        (fe/insert t {:name "Edgar" :fav-num 8}))))

(defn make-name-set [results]
  (set (map :name results)))

(defn add-jobs-table-and-data [db]
  (-> db
      (fe/create-table :jobs {:num {:type :int4}
                              :completed {:type :bool
                                          :default false}
                              :priority {:type :kw
                                         :default :normal}
                              :name {:type :str1000
                                     :default "No Name"}})
      (fe/insert :jobs {:num 1})
      (fe/insert :jobs {:num 2})
      (fe/insert :jobs {:num 3 :priority :high})))

(defn make-db2 []
  (-> (create-db)
      (add-jobs-table-and-data)))

(defn make-multi-table-db []
  (-> (create-db)
      (populate-db)
      (add-jobs-table-and-data)))

(defn ordered? [coll & dir]
  (let [op (case  (first dir)
             :asc <=
             :desc >=
             <=)]
    (or (nil? coll)
        (apply op coll))))
