(ns freedomdb.mem-avl-kv-store
  (:require
   [clojure.data.avl :as avl]
   [clojure.string :refer [starts-with?]]
   [farbetter.utils :as u
    :refer [throw-far-error #?@(:clj [inspect sym-map])]]
   [freedomdb.kv-store :refer [KVStore]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :refer [inspect sym-map]])))

(declare filter-matches)

(defrecord MemAVLKVStore [metadata rvi vri]
  KVStore
  (get- [this keyspace k]
    (get-in this [keyspace k]))

  (put- [this keyspace k v]
    (assoc-in this [keyspace k] v))

  (remove- [this keyspace k]
    (update-in this [keyspace] dissoc k))

  (keys- [this keyspace]
    (keys (get this keyspace)))

  (filter- [this keyspace options]
    (let [{:keys [output prefix filter-op filter-val]} options
          starts-with-pred (fn [[s _]]
                             (starts-with? s prefix))
          matches (take-while starts-with-pred
                              (subseq (get this keyspace) > prefix))]
      (cond->> matches
        filter-op (filter-matches filter-op filter-val)
        (= :keys-only output) (map first)
        (= :values-only output) (map second)))))

(defn make-mem-avl-kv-store []
  (->MemAVLKVStore (avl/sorted-map) (avl/sorted-map) (avl/sorted-map)))

;;;;;;;;; Helper fns ;;;;;;;;;

(defn filter-matches [filter-op filter-val matches]
  (let [filter-pred (case filter-op
                      :< neg?
                      :<= #(or (neg? %) (zero? %))
                      :> pos?
                      :>= #(or (pos? %) (zero? %)))
        compare-pred #(filter-pred (compare (first %) filter-val))]
    (filter compare-pred matches)))
