(ns farbetter.chumbawamba.keep-alive
  (:require
   [#?(:clj clojure.core.async :cljs cljs.core.async)
    :refer [<! timeout]]
   [farbetter.utils :refer
    [get-current-time-ms throw-far-error #?@(:clj [go-safe inspect sym-map])]]
   [taoensso.timbre :as timbre
    #?(:clj :refer :cljs :refer-macros) [debugf errorf infof]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :refer [go-safe inspect sym-map]])))

(def min-wait-ms 500)
#?(:cljs (def Exception js/Error))

(defprotocol IKeepAlive
  (reset-keep-alive [this])
  (start [this])
  (stop [this]))

(defrecord KeepAlive [next-keep-alive-time-ms active?
                      keep-alive-ms keep-alive-fn]
  IKeepAlive
  (reset-keep-alive [this]
    (reset! next-keep-alive-time-ms (+ (get-current-time-ms)
                                       keep-alive-ms)))
  (start [this]
    (when-not @active?
      (reset! active? true)
      (reset-keep-alive this)
      (go-safe
       (loop []
         (<! (timeout min-wait-ms))
         (when (> (get-current-time-ms) @next-keep-alive-time-ms)
           (try
             (keep-alive-fn)
             (reset-keep-alive this)
             (catch Exception e
               (stop this))))
         (when @active?
           (recur))))))
  (stop [this]
    (reset! active? false)))

(defn make-keep-alive [keep-alive-ms keep-alive-fn]
  (let [next-keep-alive-time-ms (atom nil)
        active? (atom false)]
    (map->KeepAlive (sym-map next-keep-alive-time-ms active?
                             keep-alive-ms keep-alive-fn))))
