# chumbawamba

![](docs/tubthumping.jpg)

A resilient websocket client library

## Installation via Leiningen
![Clojars Project](http://clojars.org/farbetter/chumbawamba/latest-version.svg)

## Features:
* Binary and text messages
* Clojure and Clojurescript support
* Reconnection on websocket close \(*I get knocked down, but I get up again...*\)
* Configurable keepalive

## Usage
Note that on node.js, you must first install the "ws" module via npm:
```sh
$ npm install --save ws
```

### Example usage in REPL:
```clj
(require '[farbetter.chumbawamba :as ch])
(def uri "wss://echo.websocket.org")
(def keepalive-msg "ping")
(def on-rcv #(println "Got:" %))
(def ws (ch/make-resilient-ws uri keepalive-msg on-rcv))
(ch/send ws "He sings the songs that remind him of the good times")
```

See docstrings for more details.


## License
Distributed under the [Apache License 2.0](http://www.apache.org/licenses/LICENSE-2.0.txt)

Copyright © 2015 FarBetter, Inc.