(ns leiningen.new.far-lib
  "Generate a new FarBetter library project."
  (:require [leiningen.new.templates :refer [renderer year project-name
                                             ->files sanitize-ns name-to-path
                                             multi-segment]]
            [leiningen.core.main :as main]
            [clojure.string :as string]))

(def render (renderer "far-lib"))

(defn far-lib
  "A template for FarBetter private libraries"
  [lib-name]
  (let [name (if (= 1 (count (string/split lib-name #"/")))
               (str "farbetter/" lib-name)
               lib-name)
        main-ns (multi-segment (sanitize-ns name))
        data {:raw-name name
              :name (project-name name)
              :namespace main-ns
              :nested-dirs (name-to-path main-ns)
              :year (year)}]
    (main/info "Generating a new FarBetter private library project called"
          name "based on the far-lib template. This template is intended for"
          "libraries, not applications. Use the far-app template for"
          "applications.")
    (->files data
             ["LICENSE" (render "LICENSE" data)]
             ["README.md" (render "README.md" data)]
             ["src/{{nested-dirs}}.clj" (render "core.clj" data)]
             [".gitignore" (render "gitignore" data)]
             ["project.clj" (render "project.clj" data)]
             "resources")))
