(ns leiningen.new.far-app
  (:require [leiningen.new.templates :refer [renderer year project-name
                                             ->files sanitize-ns name-to-path
                                             multi-segment]]
            [leiningen.core.main :as main]))

(def render (renderer "far-app"))

(defn far-app
  "A template for FarBetter private applications"
  [name]
  (let [main-ns (multi-segment (sanitize-ns name))
        data {:raw-name name
              :name (project-name name)
              :namespace main-ns
              :nested-dirs (name-to-path main-ns)
              :year (year)}]
    (main/info "Generating a new FarBetter private app project called"
          name "based on the far-app template. This template is intended for"
          "apps (programs), not libraries. Use the far-lib template for"
          "libraries.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)]
             [".gitignore" (render "gitignore" data)]
             ["src/{{nested-dirs}}.clj" (render "core.clj" data)]
             ["LICENSE" (render "LICENSE" data)]
             "resources")))
