;;----------------------------------------------------------------------------
;; Copyright 2011 Factual, Inc.
;; All Rights Reserved.
;;
;; This is UNPUBLISHED PROPRIETARY SOURCE CODE of Factual, Inc.
;; Factual, Inc. reserves all rights in the source code as
;; delivered. The source code and all contents of this file, may not be
;; used, copied, modified, distributed, sold, disclosed to third parties
;; or duplicated in any form, in whole or in part, for any purpose,
;; without the prior written permission of Factual, Inc.
;;----------------------------------------------------------------------------

(ns leafgrabber.register)


(def extractor-groups
  (atom {}))

(defn add-extractor-group-tuple
  [group-name tuple]
  (swap! extractor-groups assoc
         group-name tuple))

(defn register-extractor-group
  "Registered extractor groups can be a collection of fns to apply to pages, or a collection of
   extractor names and a single fn of arity two to apply to extractor names and pages."

  ([group-name extractor-fns]
     (add-extractor-group-tuple group-name [extractor-fns]))

  ([group-name extractor-names extractor-fn]
     (add-extractor-group-tuple group-name [extractor-names extractor-fn])))
