/*
 * Decompiled with CFR 0.152.
 */
package com.factual.honey.parse;

import com.factual.driver.FieldFilter;
import com.factual.driver.Filter;
import com.factual.driver.FilterGroup;
import com.factual.driver.Query;
import com.factual.honey.adapt.ExpressionVisitorAdapter;
import com.factual.honey.preprocess.Snipper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SubSelect;

public class WhereVisitor
extends ExpressionVisitorAdapter {
    private FilterGroup filters;
    private FilterGroup f;
    private final List<FilterGroup> filterStack = Lists.newArrayList();

    public void addFilters(Query query) {
        if (this.filters != null) {
            query.add((Filter)this.filters);
        }
    }

    @Override
    public void visit(Parenthesis p) {
        if (p.isNot()) {
            throw new UnsupportedOperationException("Aaron has not implemented NOT, yet. :-(");
        }
        p.getExpression().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(AndExpression expr) {
        this.pushF(new FilterGroup(new Filter[0]));
        expr.getLeftExpression().accept((ExpressionVisitor)this);
        expr.getRightExpression().accept((ExpressionVisitor)this);
        this.popF();
    }

    @Override
    public void visit(OrExpression expr) {
        this.pushF(new FilterGroup(new Filter[0]).asOR());
        expr.getLeftExpression().accept((ExpressionVisitor)this);
        expr.getRightExpression().accept((ExpressionVisitor)this);
        this.popF();
    }

    @Override
    public void visit(EqualsTo expr) {
        this.addFilter((BinaryExpression)expr, "$eq");
    }

    @Override
    public void visit(GreaterThan expr) {
        this.addFilter((BinaryExpression)expr, "$gt");
    }

    @Override
    public void visit(GreaterThanEquals expr) {
        this.addFilter((BinaryExpression)expr, "$gte");
    }

    @Override
    public void visit(InExpression in) {
        ItemsList list = in.getItemsList();
        final ArrayList inArgs = Lists.newArrayList();
        list.accept(new ItemsListVisitor(){

            public void visit(ExpressionList exprs) {
                for (Object e : exprs.getExpressions()) {
                    inArgs.add(WhereVisitor.this.coerce((Expression)e));
                }
            }

            public void visit(SubSelect subsel) {
            }
        });
        String field = in.getLeftExpression().toString();
        if (in.isNot()) {
            this.addFilter("$nin", field, inArgs);
        } else {
            this.addFilter("$in", field, inArgs);
        }
    }

    @Override
    public void visit(IsNullExpression isnull) {
        this.ensureFilters();
        String field = isnull.getLeftExpression().toString();
        this.f.add((Filter)new FieldFilter("$blank", field, (Object)(!isnull.isNot() ? 1 : 0)));
    }

    @Override
    public void visit(LikeExpression like) {
        if (like.isNot()) {
            throw new UnsupportedOperationException("Negation of full text search is not supported");
        }
        String fieldName = like.getLeftExpression().toString();
        String termWithWilds = Snipper.in("'").snip(like.getRightExpression().toString()).middle();
        String term = termWithWilds.replace("%", "");
        boolean wildAtStart = termWithWilds.startsWith("%");
        boolean wildAtEnd = termWithWilds.endsWith("%");
        this.ensureFilters();
        if (!wildAtStart && wildAtEnd) {
            this.f.add((Filter)new FieldFilter("$bw", fieldName, (Object)term));
        } else {
            if (wildAtStart && !wildAtEnd) {
                throw new UnsupportedOperationException("ends-with is not supported");
            }
            this.f.add((Filter)new FieldFilter("$search", fieldName, (Object)term));
        }
    }

    @Override
    public void visit(MinorThan expr) {
        this.addFilter((BinaryExpression)expr, "$lt");
    }

    @Override
    public void visit(MinorThanEquals expr) {
        this.addFilter((BinaryExpression)expr, "$lte");
    }

    @Override
    public void visit(NotEqualsTo expr) {
        this.addFilter((BinaryExpression)expr, "$neq");
    }

    private void pushF(FilterGroup filter) {
        if (this.filters == null) {
            this.filters = filter;
        } else {
            this.filters.add((Filter)filter);
        }
        this.f = filter;
        this.filterStack.add(filter);
    }

    private void popF() {
        int i = this.filterStack.size() - 1;
        this.filterStack.remove(i);
        this.f = this.filterStack.isEmpty() ? null : this.filterStack.get(i - 1);
    }

    private void addFilter(BinaryExpression expr, String op) {
        this.ensureFilters();
        String field = expr.getLeftExpression().toString();
        Object val = this.coerce(expr.getRightExpression());
        val = this.stripDoubleQuotes(val);
        this.f.add((Filter)new FieldFilter(op, field, val));
    }

    private Object stripDoubleQuotes(Object val) {
        if (val instanceof String && ((String)val).startsWith("\"") && ((String)val).endsWith("\"")) {
            val = val.toString().substring(1, val.toString().length() - 1);
        }
        return val;
    }

    private void addFilter(String op, String field, List<Object> args) {
        this.ensureFilters();
        this.f.add((Filter)new FieldFilter(op, field, args));
    }

    private void ensureFilters() {
        if (this.filters == null) {
            this.f = this.filters = new FilterGroup(new Filter[0]);
        }
    }

    private Object coerce(Expression expr) {
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String str = expr.toString().toLowerCase();
            if ("true".equals(str)) {
                return true;
            }
            if ("false".equals(str)) {
                return false;
            }
            return expr.toString();
        }
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        return expr.toString();
    }
}

