/*
 * Decompiled with CFR 0.152.
 */
package com.factual.honey.parse;

import com.factual.driver.Query;
import com.factual.honey.parse.ParseException;
import com.factual.honey.parse.WhereVisitor;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.Union;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang.StringUtils;

public class SqlParser
implements SelectVisitor,
StatementVisitor,
FromItemVisitor {
    private final Query query;
    private String tableName;
    private boolean hasCountFn;

    public SqlParser(Query query) {
        this.query = query;
    }

    public String parse(String sql) {
        Statement statement = this.parse(new StringReader(sql));
        if (statement instanceof Select) {
            statement.accept((StatementVisitor)this);
            return this.tableName;
        }
        throw new IllegalArgumentException("Expected a SELECT statement");
    }

    private Statement parse(StringReader sql) {
        try {
            return new CCJSqlParserManager().parse((Reader)sql);
        }
        catch (JSQLParserException jsqlpe) {
            throw ParseException.from(jsqlpe);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasCountFn() {
        return this.hasCountFn;
    }

    public void visit(Select sel) {
        sel.getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(PlainSelect select) {
        List orders;
        Limit limit;
        List items = select.getSelectItems();
        if (!"*".equals(items.get(0).toString())) {
            this.parseSelectCols(items);
        }
        FromItem from = select.getFromItem();
        from.accept((FromItemVisitor)this);
        if (select.getWhere() != null) {
            WhereVisitor wv = new WhereVisitor();
            select.getWhere().accept((ExpressionVisitor)wv);
            wv.addFilters(this.query);
        }
        if ((limit = select.getLimit()) != null) {
            this.query.limit(limit.getRowCount());
            if (limit.getOffset() > 0L) {
                this.query.offset(limit.getOffset());
            }
        }
        if ((orders = select.getOrderByElements()) != null) {
            for (Object o : orders) {
                OrderByElement sort = (OrderByElement)o;
                String fieldName = sort.getExpression().toString();
                if (fieldName.startsWith("_")) {
                    fieldName = fieldName.replaceFirst("_", "\\$");
                }
                if (sort.isAsc()) {
                    this.query.sortAsc(fieldName);
                    continue;
                }
                this.query.sortDesc(fieldName);
            }
        }
    }

    private void parseSelectCols(List<?> items) {
        String[] columns = new String[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            String column = items.get(i).toString();
            if (StringUtils.startsWithIgnoreCase((String)column, (String)"count")) {
                this.parseCount(column.toLowerCase());
                return;
            }
            if (column.startsWith("_")) {
                column = column.replaceFirst("_", "\\$");
            }
            columns[i] = column;
        }
        this.query.only(columns);
    }

    private void parseCount(String countFn) {
        String col = StringUtils.substringBetween((String)countFn, (String)"(", (String)")");
        this.hasCountFn = true;
        this.query.includeRowCount();
        if (!"*".equals(col)) {
            this.query.criteria(col).notBlank();
        }
    }

    public void visit(Table table) {
        this.tableName = table.getName().toLowerCase().replace('_', '-');
    }

    public void visit(SubSelect arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(SubJoin arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(Delete arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(Update arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(Insert arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(Replace arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(Drop arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(Truncate arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(CreateTable arg0) {
        throw new UnsupportedOperationException();
    }

    public void visit(Union arg0) {
        throw new UnsupportedOperationException();
    }
}

