/*
 * Decompiled with CFR 0.152.
 */
package com.factual.honey.preprocess;

import com.factual.honey.preprocess.Snip;
import org.apache.commons.lang.StringUtils;

public class Snipper {
    private final String startTag;
    private final String endTag;

    public static Snipper in(String startTag, String endTag) {
        return new Snipper(startTag, endTag);
    }

    public static Snipper in(String tag) {
        return new Snipper(tag, tag);
    }

    public static Snipper after(String tag) {
        return new Snipper(tag);
    }

    private Snipper(String startTag, String endTag) {
        this.startTag = startTag;
        this.endTag = endTag;
    }

    private Snipper(String startTag) {
        this.startTag = startTag;
        this.endTag = null;
    }

    public Snip snip(String str) {
        int end;
        int start = StringUtils.indexOfIgnoreCase((String)str, (String)this.startTag);
        if (this.endTag == null) {
            String first = str.substring(0, start);
            String middle = str.substring(start);
            String last = "";
            return new Snip(first, middle, last);
        }
        if (start > -1 && (end = str.indexOf(this.endTag, start + this.startTag.length())) > -1) {
            String first = str.substring(0, start);
            String middle = str.substring(start + this.startTag.length(), end);
            String last = str.substring(end += this.endTag.length());
            return new Snip(first, middle, last);
        }
        return null;
    }
}

