/*
 * Decompiled with CFR 0.152.
 */
package com.factual.honey;

import com.factual.driver.Tabular;
import com.google.common.collect.Lists;
import com.inamik.utils.SimpleTableFormatter;
import com.inamik.utils.TableFormatter;
import java.util.List;
import java.util.Map;

public class TabularFormatter {
    private List<String> columns;
    private String firstCol;

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void setFirstColumn(String col) {
        this.firstCol = col;
    }

    public String formatCount(Tabular table) {
        SimpleTableFormatter tf = new SimpleTableFormatter(true);
        tf.nextRow();
        tf.nextCell().addLine("count");
        tf.nextRow();
        tf.nextCell().addLine(table.getData().size() + "");
        return this.asTextTable((TableFormatter)tf);
    }

    public String format(Tabular table) {
        if (!table.getData().isEmpty()) {
            TableFormatter tf = new SimpleTableFormatter(true).nextRow();
            this.setColHeadings(tf, this.prepCols(table));
            this.formatRows(table, tf);
            return this.asTextTable(tf);
        }
        return "[No Results]\n";
    }

    private void formatRows(Tabular table, TableFormatter tf) {
        for (Map record : table.getData()) {
            tf.nextRow();
            for (String col : this.columns) {
                Object valObj = record.get(col);
                String val = valObj == null ? "null" : valObj.toString();
                tf.nextCell().addLine(val);
            }
        }
    }

    private void setColHeadings(TableFormatter tf, List<String> columns) {
        for (String col : columns) {
            tf.nextCell().addLine(col.toString());
        }
    }

    private List<String> prepCols(Tabular table) {
        this.ensureNonNullCols(table);
        this.obeyFirst();
        return this.columns;
    }

    private void ensureNonNullCols(Tabular table) {
        if (this.columns == null) {
            this.columns = Lists.newArrayList();
            for (String col : ((Map)table.getData().iterator().next()).keySet()) {
                this.columns.add(col);
            }
        }
    }

    private void obeyFirst() {
        if (this.firstCol != null) {
            this.columns.remove(this.firstCol);
            this.columns.add(0, this.firstCol);
        }
    }

    private String asTextTable(TableFormatter tf) {
        StringBuilder sbul = new StringBuilder();
        for (String line : tf.getFormattedTable()) {
            sbul.append(line).append("\n");
        }
        return sbul.toString();
    }
}

