(ns shadow.cljs.test
  (:require [shadow.cljs.build :as cljs]
            [shadow.cljs.common :as common]
            [shadow.cljs.schemas :as schemas]
            [clojure.string :as str]))

(def has-tests?-xf
  (filter cljs/has-tests?))

(defn test-namespace-xf []
  (comp common/remove-jar-xf
        has-tests?-xf
        common/namespace-xf
        (map distinct)))

(defn find-affected-test-namespaces-from-sources
  [state changed-sources]
  (let [dependents (common/sources->dependents state changed-sources)]
    (vec (sequence (test-namespace-xf)
                   (concat changed-sources dependents)))))

(defn find-all-test-namespaces
  [state]
  (vec (sequence (test-namespace-xf) (common/source-names state))))

(defn find-affected-test-namespaces
  [state changed-source-names]
  (let [dependents (cljs/find-dependents-for-names state changed-source-names)]
    (vec (sequence (comp (common/source-xf state) (test-namespace-xf))
                   (concat changed-source-names dependents)))))


(defn to-source-name [state source-name]
  (cond
   (string? source-name)
   source-name
   (symbol? source-name)
   (get-in state [:provide->source source-name])
   :else
   (throw (ex-info (format "no source for %s" source-name)
                   {:source-name source-name}))))



